/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.sorting;

import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.StatFormat;
import se.mickelus.tetra.gui.stats.sorting.IStatSorter;

@ParametersAreNonnullByDefault
public class BasicStatSorter
implements IStatSorter {
    private final IStatGetter getter;
    private final String name;
    private final StatFormat statFormat;
    private String suffix;
    private boolean inverted;

    public BasicStatSorter(IStatGetter getter, String name, StatFormat statFormat) {
        this.getter = getter;
        this.name = name;
        this.statFormat = statFormat;
    }

    public BasicStatSorter setInverted() {
        this.inverted = true;
        return this;
    }

    public BasicStatSorter setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Override
    public String getName() {
        if (this.suffix != null) {
            return I18n.m_118938_((String)this.name, (Object[])new Object[0]) + " " + I18n.m_118938_((String)this.suffix, (Object[])new Object[0]);
        }
        return I18n.m_118938_((String)this.name, (Object[])new Object[0]);
    }

    @Override
    public <T> Comparator<T> compare(Player player, Function<? super T, ItemStack> keyExtractor) {
        if (this.inverted) {
            return Comparator.comparing(a -> this.getter.getValue(player, (ItemStack)keyExtractor.apply(a)));
        }
        return Comparator.comparing(a -> -this.getter.getValue(player, (ItemStack)keyExtractor.apply(a)));
    }

    @Override
    @Nullable
    public String getValue(Player player, ItemStack itemStack) {
        return this.statFormat.get(this.getter.getValue(player, itemStack));
    }

    @Override
    public int getWeight(Player player, ItemStack itemStack) {
        return this.getter.shouldShow(player, itemStack, itemStack) ? 1 : 0;
    }
}

